/*
 * Decompiled with CFR 0.152.
 */
package com.ahsay.afc.lotus;

import com.ahsay.afc.lotus.LotusBackupManager$Domino;
import com.ahsay.afc.lotus.LotusBackupManager$ELFArchitectureIdentifier;
import com.ahsay.afc.lotus.LotusBackupManager$Notes;
import com.ahsay.afc.lotus.LotusBackupManager$NotesIniFile;
import com.ahsay.afc.lotus.LotusExpt;
import com.ahsay.afc.lotus.LotusExpt$DominoNotInstalled;
import com.ahsay.afc.lotus.LotusExpt$InvalidNotesIni;
import com.ahsay.afc.lotus.LotusExpt$InvalidVM;
import com.ahsay.afc.lotus.LotusExpt$NotesNotInstalled;
import com.ahsay.afc.lotus.LotusFile;
import com.ahsay.afc.util.N;
import com.ahsay.afc.util.U;
import com.ahsay.afc.util.v;
import com.ahsay.obc.f;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;

public abstract class LotusBackupManager {
    public static final boolean a = "true".equalsIgnoreCase(System.getProperty("com.ahsay.afc.lotus.debug"));
    public static final String b = System.getProperty("com.ahsay.afc.lotus.native.debug");
    public static final String c = System.getProperty("com.ahsay.afc.lotus.native.minbufreesize");
    protected String d = null;
    private static boolean i = false;
    private static LotusBackupManager j = null;
    public static final String[] e = new String[]{"box", "nsf", "ntf"};
    public static final String[] f = new String[]{"txn", "lfh"};
    public static final List g = Arrays.asList(e);
    String h;

    public String getNotesIniPath() {
        return this.d;
    }

    public abstract String getAppDir();

    public abstract String getDataDir();

    public abstract String getVersion();

    public abstract LotusFile[] listFiles(String var1, String var2);

    public abstract LotusFile[] listDBFiles(String var1, String var2);

    public abstract String backupDB(String var1, String var2, String var3, long var4);

    public abstract String copyFile(String var1, String var2, String var3, long var4);

    public String copyFileAbsolute(String string, String string2) {
        return this.copyNotesFile(string, string2);
    }

    public String spoolArchiveLogs(String string) {
        return this.spoolArchiveLogs(string, "");
    }

    public abstract String spoolArchiveLogs(String var1, String var2);

    public abstract String getEnvironmentString(String var1);

    public abstract String recoverBackupFile(String var1, String var2, boolean var3, boolean var4, boolean var5);

    public abstract String restoreDB(String var1, String var2, String var3);

    public abstract String getTransLogStyle();

    public abstract boolean setEnvironmentInt(String var1, int var2);

    public abstract boolean setEnvironmentVariable(String var1, String var2);

    public abstract void restore(String var1, String var2, String var3, String var4, String var5, boolean var6, boolean var7, boolean var8);

    public native boolean chownNotes(String var1);

    public native boolean mkdirs(String var1);

    protected native String getNotesAppDir(int var1);

    protected native String getNotesDataDir();

    protected native String getNotesVersion();

    protected native String[] listNotesFiles(String var1, String var2);

    protected native String[] listNotesDBFiles(String var1, String var2);

    protected native String backupNotesDB(String var1, String var2);

    protected native String copyNotesDataFile(String var1, String var2, String var3);

    protected native String copyNotesFile(String var1, String var2);

    protected native String spoolNotesArchiveLogs(String var1, String var2);

    protected native String getNotesEnvironmentString(String var1);

    protected native String recoverNotesBackupFile(String var1, String var2, boolean var3, boolean var4, boolean var5);

    protected native String restoreNotesDB(String var1, String var2, String var3);

    protected native String getNotesTransLogStyle();

    protected native boolean setNotesEnvironmentInt(String var1, int var2);

    protected native boolean setNotesEnvironmentVariable(String var1, String var2);

    protected native void appendJavaLibraryPath(String var1);

    protected native int initNotes(int var1, String var2, String var3);

    protected native void termNotes();

    protected native int initNotesThread();

    protected native void termNotesThread();

    protected native void setDebug(int var1);

    protected native void setPreBackupAction(int var1, int var2);

    protected void a() {
        String string = b;
        if (string != null && !"".equals(string)) {
            this.setDebug(Integer.valueOf(string));
        } else {
            this.setDebug(0);
        }
    }

    protected void a(boolean bl2, int n2) {
        int n3 = -1;
        boolean bl3 = bl2 && n2 == 0;
        String string = c;
        if (string != null && !"".equals(string)) {
            n3 = Integer.valueOf(string);
        }
        this.setPreBackupAction(n3, bl3 ? 1 : 0);
    }

    public static LotusBackupManager getNotesManager(String string, String string2) {
        LotusBackupManager$NotesIniFile lotusBackupManager$NotesIniFile = LotusBackupManager.b(string);
        if (lotusBackupManager$NotesIniFile == null) {
            throw new LotusExpt$InvalidNotesIni(string);
        }
        if (j != null && LotusBackupManager.j.d.equals(string)) {
            return j;
        }
        LotusBackupManager.releaseManager();
        LotusBackupManager$Notes lotusBackupManager$Notes = new LotusBackupManager$Notes(string);
        int n2 = lotusBackupManager$Notes.d();
        lotusBackupManager$Notes.a();
        int n3 = lotusBackupManager$Notes.initNotes(0, string2, string);
        if (a) {
            System.out.println("[LotusBackupManager] getNotesManager initial (" + n3 + ") : " + string);
        }
        lotusBackupManager$Notes.a(false, n2);
        j = lotusBackupManager$Notes;
        return lotusBackupManager$Notes;
    }

    public static LotusBackupManager getDominoManager(String string, String string2) {
        LotusBackupManager$NotesIniFile lotusBackupManager$NotesIniFile = LotusBackupManager.b(string);
        if (lotusBackupManager$NotesIniFile == null) {
            throw new LotusExpt$InvalidNotesIni(string);
        }
        if (j != null && LotusBackupManager.j.d.equals(string)) {
            return j;
        }
        LotusBackupManager.releaseManager();
        LotusBackupManager$Domino lotusBackupManager$Domino = new LotusBackupManager$Domino(string);
        int n2 = lotusBackupManager$Domino.d();
        lotusBackupManager$Domino.a();
        int n3 = lotusBackupManager$Domino.initNotes(1, string2, string);
        if (a) {
            System.out.println("[LotusBackupManager] getDominoManager initial (" + n3 + ") : " + string);
        }
        lotusBackupManager$Domino.a(true, n2);
        j = lotusBackupManager$Domino;
        return lotusBackupManager$Domino;
    }

    public static void releaseManager() {
        if (j != null) {
            if (a) {
                System.out.println("[LotusBackupManager] releaseManager");
            }
            j.termNotes();
            j = null;
        }
    }

    public static boolean initThread() {
        if (j != null) {
            if (a) {
                System.out.println("[LotusBackupManager] initThread");
            }
            if (j.initNotesThread() == 0) {
                return true;
            }
        }
        return false;
    }

    public static void termThread() {
        if (j != null) {
            if (a) {
                System.out.println("[LotusBackupManager] termThread");
            }
            j.termNotesThread();
        }
    }

    public static int getLibraryArchitecture(boolean bl2, String string) {
        int n2 = com.ahsay.obc.f.I ? LotusBackupManager.a(bl2) : LotusBackupManager.a(string);
        return n2;
    }

    protected static int a(boolean bl2) {
        U u2 = new U();
        String string = bl2 ? "HKEY_LOCAL_MACHINE\\Software\\Lotus\\Domino\\Path" : "HKEY_LOCAL_MACHINE\\Software\\Lotus\\Notes\\Path";
        String string2 = u2.getRegistryValue(string, 0, 1);
        if (!"".equals(string2)) {
            return com.ahsay.obc.f.D ? 1 : 0;
        }
        if (com.ahsay.obc.f.D) {
            string2 = u2.getRegistryValue(string, 512, 1);
            if (!"".equals(string2)) {
                return 0;
            }
        } else {
            string2 = u2.getRegistryValue(string, 256, 1);
            if (!"".equals(string2)) {
                return 1;
            }
        }
        LotusBackupManager.a(bl2, "Failed to read registry from \"" + string + "\"");
        return -1;
    }

    protected static int a(String string) {
        LotusBackupManager$NotesIniFile lotusBackupManager$NotesIniFile = LotusBackupManager.b(string);
        try {
            String string2 = new File(lotusBackupManager$NotesIniFile.getAppDir(), "libnotes.so").getAbsolutePath();
            return LotusBackupManager$ELFArchitectureIdentifier.getELFFileArchitecture(string2);
        }
        catch (Exception exception) {
            throw new LotusExpt(exception.getMessage());
        }
    }

    private static LotusBackupManager$NotesIniFile b(String string) {
        return new LotusBackupManager$NotesIniFile(string);
    }

    public static String getNotesDefaultNotesIniPath() {
        return "";
    }

    public static String getDominoDefaultNotesIniPath() {
        return "";
    }

    protected LotusBackupManager(String string, String string2) {
        this.d = string2;
        if (!com.ahsay.obc.f.I && !com.ahsay.obc.f.aD) {
            throw new RuntimeException("[LotusBackupManager] OS not supported: " + com.ahsay.obc.f.ao);
        }
        if ("Notes".equals(string) && com.ahsay.obc.f.D) {
            throw new LotusExpt$InvalidVM("Please use a 32-bit JVM to backup IBM Notes Client");
        }
        if (i) {
            return;
        }
        String string3 = LotusBackupManager.getNativeLibName("LotusJNI");
        String string4 = com.ahsay.obc.f.I ? string3 + ".dll" : "lib" + string3 + ".so";
        try {
            System.loadLibrary(string3);
            i = true;
            if (com.ahsay.obc.f.I) {
                String string5 = System.getProperty("java.library.path");
                this.appendJavaLibraryPath(string5);
            }
        }
        catch (SecurityException securityException) {
            String string6 = "[SecurityException] Unable to load " + string4 + ". Error=" + securityException.getMessage();
            throw new LotusExpt(string6);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            String string7 = "[UnsatisfiedLinkError] Unable to load " + string4 + "." + " Working Directory = '" + System.getProperty("user.dir") + "'" + " Library Path = '" + System.getProperty("java.library.path") + "'" + " Error = '" + LotusBackupManager.getStackMessages(unsatisfiedLinkError) + "'";
            throw new LotusExpt(string7);
        }
    }

    public static final String getNativeLibName(String string) {
        if (com.ahsay.obc.f.I) {
            string = string + "Win";
        } else if (com.ahsay.obc.f.aD) {
            string = string + "Lin";
        }
        string = com.ahsay.obc.f.D ? string + "X64" : string + "X86";
        return string;
    }

    public LotusFile[] listFiles(String string) {
        return this.listFiles("\"\"", string);
    }

    public LotusFile[] listDBFiles(String string) {
        return this.listDBFiles("\"\"", string);
    }

    public String copyFile(String string, String string2, long l2) {
        return this.copyFile("\"\"", string, string2, l2);
    }

    public String getTransactionLogDir() {
        String string = this.getEnvironmentString("TRANSLOG_Path");
        if (string != null && !string.equals("")) {
            if (com.ahsay.obc.f.I && !string.contains(":") && !string.startsWith("\\\\")) {
                string = N.c(this.getDataDir(), File.separator) + File.separator + string;
            } else if (!com.ahsay.obc.f.I && !string.startsWith("/")) {
                string = N.c(this.getDataDir(), File.separator) + File.separator + string;
            }
        }
        return string;
    }

    public String backupDB(String string, String string2, long l2) {
        return this.backupDB("\"\"", string, string2, l2);
    }

    protected abstract void b();

    protected abstract void c();

    protected static void a(boolean bl2, String string) {
        LotusExpt lotusExpt;
        if (bl2) {
            lotusExpt = new LotusExpt$DominoNotInstalled();
            if (string != null && !"".equals(string)) {
                lotusExpt = new LotusExpt$DominoNotInstalled(lotusExpt.getMessage() + ", Reason=" + string);
            }
        } else {
            lotusExpt = new LotusExpt$NotesNotInstalled();
            if (string != null && !"".equals(string)) {
                lotusExpt = new LotusExpt$NotesNotInstalled(lotusExpt.getMessage() + ", Reason=" + string);
            }
        }
        throw lotusExpt;
    }

    protected int d() {
        boolean bl2 = this instanceof LotusBackupManager$Domino;
        int n2 = LotusBackupManager.getLibraryArchitecture(bl2, this.getNotesIniPath());
        if (n2 == 0) {
            if (com.ahsay.obc.f.D) {
                this.b();
            }
        } else if (!com.ahsay.obc.f.D) {
            this.c();
        }
        return n2;
    }

    public static boolean isDatabase(LotusFile lotusFile) {
        return LotusBackupManager.isDatabase(lotusFile.getFileExtension());
    }

    public static boolean isDatabase(String string) {
        return g.contains(string.toLowerCase());
    }

    public static boolean isTransLogFile(LotusFile lotusFile) {
        return LotusBackupManager.isTransLogFile(lotusFile.getFullPath());
    }

    public static boolean isTransLogFile(String string) {
        String string2 = LotusBackupManager.getExtention(string);
        return Arrays.asList(f).contains(string2.toLowerCase());
    }

    public boolean isTransLogEnabled() {
        String string = this.getTransactionLogDir();
        return string != null && string.length() > 0;
    }

    public static String getExtention(String string) {
        if (string == null) {
            return "";
        }
        int n2 = string.lastIndexOf(46);
        if (n2 == string.length()) {
            return "";
        }
        return string.substring(n2 + 1, string.length());
    }

    public void startDominoRestore(String string) {
        this.h = this.getTransactionLogDir();
        File file = new File(this.h, "nlogctrl.lfh");
        if (file.delete() && this.setNotesEnvironmentInt("TRANSLOG_Recreate_Logctrl", 1)) {
            System.out.println("TRANSLOG_Recreate_Logctrl=1 is written into " + string);
        } else {
            System.out.println(file.getPath() + " is removed");
        }
        if (this.setNotesEnvironmentInt("TRANSLOG_MEDIAONLY", 0)) {
            System.out.println("TRANSLOG_MEDIAONLY=1 is written into " + string);
        }
    }

    public void backup(String string, String string2) {
        LotusFile[] lotusFileArray;
        String string3 = "";
        for (LotusFile lotusFile : lotusFileArray = this.listDBFiles(string)) {
            String string4 = string2 + File.separator + lotusFile.getRelativeFilePath();
            if (!lotusFile.getFileName().startsWith("webadmin.ntf")) {
                // empty if block
            }
            if (lotusFile.isDir()) {
                File file = new File(string2, lotusFile.getRelativeFilePath());
                if (!v.c(file) && !v.b(file, true)) {
                    System.out.println("fail to create " + file.getPath());
                    continue;
                }
                this.backup(lotusFile.getFileName(), string2);
                continue;
            }
            if (LotusBackupManager.isDatabase(lotusFile.getFileExtension())) {
                string3 = this.backupDB(lotusFile.getFullPath(), string4, lotusFile.getLastModified());
                System.out.println("backup:" + string3 + ", " + lotusFile.getFileName());
                if (string3.equals("AFC_LOTUS_SUCCESS")) continue;
                v.a(lotusFile.getFullPath(), string4);
                continue;
            }
            v.a(lotusFile.getFullPath(), string4);
        }
    }

    public void restoreTransLog(String string) {
        String string2 = this.getTransactionLogDir();
        File file = new File(string);
        File file2 = new File(string2);
        if (!v.c(file2) && !v.b(file2, true)) {
            return;
        }
        System.out.println("Restore trans log " + string + ":" + string2);
        for (File file3 : file.listFiles()) {
            String string3 = file3.getAbsolutePath();
            String string4 = file3.getName();
            String string5 = string2 + File.separator + string4;
            if (string4.equals("nlogctrl.lfh")) continue;
            System.out.println(string3 + " => " + string5);
            v.a(string3, string5);
        }
    }

    public void restoreAll(String string, String string2, String string3, String string4, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        File[] fileArray;
        String string5 = string + File.separator + string2;
        String string6 = "";
        for (File file : fileArray = new File(string5).listFiles()) {
            try {
                String string7 = file.getPath();
                String string8 = v.b(string7);
                String string9 = (string2.length() > 0 ? string2 + File.separator : "") + string8;
                String string10 = string3 + File.separator + string9;
                if (file.isDirectory()) {
                    File file2 = new File(string10);
                    if (!v.c(file2) && !v.b(file2, true)) {
                        System.out.println("fail to create " + file2.getPath());
                        continue;
                    }
                    this.restoreAll(string, string9, string3, string4, bl2, bl3, bl4, bl5);
                    continue;
                }
                if (LotusBackupManager.isDatabase(LotusBackupManager.getExtention(file.getPath()))) {
                    if (string8.equals("log.nsf") || string8.equals("names.nsf")) {
                        // empty if block
                    }
                    System.out.println("++++ start restore: " + string7);
                    if (v.c(new File(string10))) {
                        string6 = this.restoreDB(string7, string10, this.getTransactionLogDir());
                        if (!string6.equals("AFC_LOTUS_SUCCESS")) {
                            System.out.println("* restore:" + string6 + ", " + string8);
                        }
                    } else {
                        v.a(string7, string10);
                    }
                    System.out.println("++++ end restore: " + string7);
                    if (!bl5) continue;
                    System.out.println("@@@@ start recover " + string10 + " " + bl2);
                    string6 = this.recoverBackupFile(string10, string4, bl2, bl3, bl4);
                    if (!string6.equals("AFC_LOTUS_SUCCESS") && !string6.equals("AFC_LOTUS_ERR_DB_NOT_LOGGED")) {
                        System.out.println("@@@@ fail recover: " + string6);
                        continue;
                    }
                    System.out.println("@@@@ end recover successfully " + string10);
                    continue;
                }
                if (LotusBackupManager.isTransLogFile(string8)) continue;
                System.out.println(string7 + " => " + string10);
                v.a(string7, string10);
            }
            catch (IOException iOException) {
                System.err.println("restoration of " + file.getName() + " failed. Reason: " + iOException.getMessage());
            }
        }
    }

    public static void main(String[] stringArray) {
        LotusBackupManager lotusBackupManager;
        String string;
        String string2 = "D:\\8252\\backupTest";
        String string3 = "C:\\Documents and Settings\\bean.lam\\.obm";
        String string4 = string2 + File.separator + "logdir";
        if (stringArray[0].equals("notes")) {
            string = stringArray.length > 2 ? stringArray[2] : "C:\\Program Files\\lotus\\notes\\notes.ini";
            lotusBackupManager = LotusBackupManager.getNotesManager(string, string3);
        } else {
            string = stringArray.length > 2 ? stringArray[2] : "C:\\Program Files\\IBM\\Lotus\\Domino\\notes.ini";
            lotusBackupManager = LotusBackupManager.getDominoManager(string, string3);
        }
        String string5 = lotusBackupManager.getDataDir();
        if (stringArray[1].equals("listFiles")) {
            LotusFile[] lotusFileArray = lotusBackupManager.listFiles("");
            System.out.println("listFiles size=" + lotusFileArray.length);
            System.out.println("*************");
            for (LotusFile lotusFile : lotusFileArray) {
                System.out.println(lotusFile.getFullPath() + ", " + lotusFile.getLastModified() + ":" + v.g(new File(lotusFile.getFullPath())));
            }
            System.out.println("*************");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStackMessages(Throwable throwable) {
        if (a) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8192);
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            try {
                throwable.printStackTrace(printStream);
                Object var4_5 = null;
                printStream.close();
            }
            catch (Throwable throwable2) {
                Object var4_6 = null;
                printStream.close();
                throw throwable2;
            }
            String string = byteArrayOutputStream.toString();
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(1024);
        Throwable throwable3 = throwable;
        do {
            if (throwable3 != throwable) {
                stringBuffer.append(", caused by ");
            }
            stringBuffer.append("[");
            stringBuffer.append(throwable3.getClass().getName());
            stringBuffer.append("] ");
            stringBuffer.append(throwable3.getMessage());
        } while ((throwable3 = throwable3.getCause()) != null);
        return stringBuffer.toString();
    }
}

