/*
 * Decompiled with CFR 0.152.
 */
package org.doublecloud.ws.util;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.xml.bind.DatatypeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectUtil {
    public static Field[] getAllFields(Class<?> c2) {
        ArrayList<Field> listOfFields = new ArrayList<Field>();
        ReflectUtil.getAllFields(c2, listOfFields);
        Field[] arrayOffields = new Field[listOfFields.size()];
        listOfFields.toArray(arrayOffields);
        return arrayOffields;
    }

    private static void getAllFields(Class<?> clazz, List<Field> listOfFields) {
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null) {
            ReflectUtil.getAllFields(superClass, listOfFields);
        }
        Field[] fields = clazz.getDeclaredFields();
        for (int i2 = 0; i2 < fields.length; ++i2) {
            listOfFields.add(fields[i2]);
        }
    }

    public static final void setArrayField(Object obj, List<Object> vimObjList, Field vimArrayField, Class<?> vimArrayType) throws IllegalAccessException {
        Object ao = Array.newInstance(vimArrayType, vimObjList.size());
        for (int i2 = 0; i2 < vimObjList.size(); ++i2) {
            Array.set(ao, i2, vimObjList.get(i2));
        }
        vimArrayField.set(obj, ao);
        vimObjList.clear();
    }

    public static final void setObjectField(Object object, Field field, String type, String value) throws IllegalArgumentException, IllegalAccessException {
        if ("String".equals(type) || "string".equals(type)) {
            field.set(object, value);
        } else if ("int".equals(type)) {
            field.set(object, Integer.parseInt(value));
        } else if ("Integer".equals(type)) {
            field.set(object, new Integer(value));
        } else if ("short".equals(type)) {
            field.set(object, Short.parseShort(value));
        } else if ("Short".equals(type)) {
            field.set(object, new Short(value));
        } else if ("byte".equals(type)) {
            field.set(object, Byte.parseByte(value));
        } else if ("Byte".equals(type)) {
            field.set(object, new Byte(value));
        } else if ("long".equals(type)) {
            field.set(object, Long.parseLong(value));
        } else if ("Long".equals(type)) {
            field.set(object, new Long(value));
        } else if ("float".equals(type)) {
            field.set(object, Float.valueOf(Float.parseFloat(value)));
        } else if ("Float".equals(type)) {
            field.set(object, new Float(value));
        } else if ("boolean".equals(type)) {
            field.set(object, Boolean.parseBoolean(value));
        } else if ("Boolean".equals(type)) {
            field.set(object, new Boolean(value));
        } else if ("Calendar".equals(type) || "dateTime".equals(type)) {
            Calendar cal = DatatypeConverter.parseTime(value);
            field.set(object, cal);
        } else if ("double".equals(type)) {
            field.set(object, Double.parseDouble(value));
        } else if ("Double".equals(type)) {
            field.set(object, new Double(value));
        } else {
            throw new RuntimeException("Unexpected Type at setObjectField: " + field.getType().getCanonicalName() + field.getName());
        }
    }

    public static void setObjectArrayField(Object object, Field field, String type, List<String> values) throws IllegalArgumentException, IllegalAccessException {
        if ("String[]".equals(type) || "string[]".equals(type)) {
            String[] vals = new String[values.size()];
            field.set(object, values.toArray(vals));
        } else if ("int[]".equals(type)) {
            field.set(object, ReflectUtil.toIntArray(values));
        } else if ("short[]".equals(type)) {
            field.set(object, ReflectUtil.toShortArray(values));
        } else if ("byte[]".equals(type)) {
            field.set(object, ReflectUtil.toByteArray(values));
        } else if ("long[]".equals(type)) {
            field.set(object, ReflectUtil.toLongArray(values));
        } else if ("float[]".equals(type)) {
            field.set(object, ReflectUtil.toFloatArray(values));
        } else if ("boolean[]".equals(type)) {
            field.set(object, ReflectUtil.toBooleanArray(values));
        } else {
            throw new RuntimeException("Unexpected Type at setObjectArrayField: " + field.getType().getCanonicalName() + field.getName());
        }
    }

    private static byte[] toByteArray(List<String> values) {
        byte[] bs = new byte[values.size()];
        for (int i2 = 0; i2 < bs.length; ++i2) {
            bs[i2] = Byte.parseByte(values.get(i2));
        }
        return bs;
    }

    private static long[] toLongArray(List<String> values) {
        long[] ls = new long[values.size()];
        for (int i2 = 0; i2 < ls.length; ++i2) {
            ls[i2] = Long.parseLong(values.get(i2));
        }
        return ls;
    }

    private static short[] toShortArray(List<String> values) {
        short[] ss = new short[values.size()];
        for (int i2 = 0; i2 < ss.length; ++i2) {
            ss[i2] = Short.parseShort(values.get(i2));
        }
        return ss;
    }

    private static float[] toFloatArray(List<String> values) {
        float[] fs = new float[values.size()];
        for (int i2 = 0; i2 < fs.length; ++i2) {
            fs[i2] = Float.parseFloat(values.get(i2));
        }
        return fs;
    }

    private static double[] toDoubleArray(List<String> values) {
        double[] ds = new double[values.size()];
        for (int i2 = 0; i2 < ds.length; ++i2) {
            ds[i2] = Double.parseDouble(values.get(i2));
        }
        return ds;
    }

    private static int[] toIntArray(List<String> values) {
        int[] is = new int[values.size()];
        for (int i2 = 0; i2 < is.length; ++i2) {
            is[i2] = Integer.parseInt(values.get(i2));
        }
        return is;
    }

    private static boolean[] toBooleanArray(List<String> values) {
        boolean[] bs = new boolean[values.size()];
        for (int i2 = 0; i2 < bs.length; ++i2) {
            bs[i2] = Boolean.parseBoolean(values.get(i2));
        }
        return bs;
    }

    public static Object parseToObject(String type, List<String> values) {
        if ("String".equals(type) || "string".equals(type)) {
            return values.get(0);
        }
        if ("String[]".equals(type)) {
            return values;
        }
        if ("int".equals(type)) {
            return new Integer(values.get(0));
        }
        if ("int[]".equals(type)) {
            return ReflectUtil.toIntArray(values);
        }
        if ("short".equals(type)) {
            return new Short(values.get(0));
        }
        if ("short[]".equals(type)) {
            return ReflectUtil.toShortArray(values);
        }
        if ("byte".equals(type)) {
            return new Byte(values.get(0));
        }
        if ("byte[]".equals(type)) {
            return ReflectUtil.toByteArray(values);
        }
        if ("long".equals(type)) {
            return new Long(values.get(0));
        }
        if ("long[]".equals(type)) {
            return ReflectUtil.toLongArray(values);
        }
        if ("float".equals(type)) {
            return new Float(values.get(0));
        }
        if ("float[]".equals(type)) {
            return ReflectUtil.toFloatArray(values);
        }
        if ("boolean".equals(type)) {
            return new Boolean(values.get(0));
        }
        if ("boolean[]".equals(type)) {
            return ReflectUtil.toBooleanArray(values);
        }
        if ("Calendar".equals(type) || "dateTime".equals(type)) {
            Calendar cal = DatatypeConverter.parseTime(values.get(0));
            return cal;
        }
        if ("double".equals(type)) {
            return new Double(values.get(0));
        }
        if ("double[]".equals(type)) {
            return ReflectUtil.toDoubleArray(values);
        }
        throw new RuntimeException("Unexpected Type at parseToObject: " + type + values.get(0));
    }
}

