/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs;

import java.util.Vector;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.impl.xs.psvi.StringList;
import org.apache.xerces.impl.xs.psvi.XSAttributeDeclaration;
import org.apache.xerces.impl.xs.psvi.XSAttributeGroupDefinition;
import org.apache.xerces.impl.xs.psvi.XSElementDeclaration;
import org.apache.xerces.impl.xs.psvi.XSModel;
import org.apache.xerces.impl.xs.psvi.XSModelGroupDefinition;
import org.apache.xerces.impl.xs.psvi.XSNamedMap;
import org.apache.xerces.impl.xs.psvi.XSNamespaceItemList;
import org.apache.xerces.impl.xs.psvi.XSNotationDeclaration;
import org.apache.xerces.impl.xs.psvi.XSObjectList;
import org.apache.xerces.impl.xs.psvi.XSTypeDefinition;
import org.apache.xerces.impl.xs.util.NSItemListImpl;
import org.apache.xerces.impl.xs.util.StringListImpl;
import org.apache.xerces.impl.xs.util.XSNamedMap4Types;
import org.apache.xerces.impl.xs.util.XSNamedMapImpl;
import org.apache.xerces.util.SymbolHash;
import org.apache.xerces.util.XMLSymbols;

public class XSModelImpl
implements XSModel {
    private static final short MAX_COMP_IDX = 14;
    private static final boolean[] GLOBAL_COMP = new boolean[]{false, true, true, true, false, true, true, false, false, false, false, true, false, true, true};
    private int fGrammarCount;
    private String[] fNamespaces;
    private SchemaGrammar[] fGrammarList;
    private SymbolHash fGrammarMap;
    private XSNamedMap[] fGlobalComponents;
    private XSNamedMap[][] fNSComponents;
    private SymbolHash[] fTables;

    public XSModelImpl(SchemaGrammar[] schemaGrammarArray) {
        int n2 = schemaGrammarArray.length;
        this.fNamespaces = new String[Math.max(n2 + 1, 5)];
        this.fGrammarList = new SchemaGrammar[Math.max(n2 + 1, 5)];
        boolean bl = false;
        int n3 = 0;
        while (n3 < n2) {
            this.fNamespaces[n3] = schemaGrammarArray[n3].getTargetNamespace();
            this.fGrammarList[n3] = schemaGrammarArray[n3];
            if (this.fNamespaces[n3] == SchemaSymbols.URI_SCHEMAFORSCHEMA) {
                bl = true;
            }
            ++n3;
        }
        if (!bl) {
            this.fNamespaces[n2] = SchemaSymbols.URI_SCHEMAFORSCHEMA;
            this.fGrammarList[n2++] = SchemaGrammar.SG_SchemaNS;
        }
        int n4 = 0;
        while (n4 < n2) {
            SchemaGrammar schemaGrammar = this.fGrammarList[n4];
            Vector vector = schemaGrammar.getImportedGrammars();
            int n5 = vector == null ? -1 : vector.size() - 1;
            while (n5 >= 0) {
                SchemaGrammar schemaGrammar2 = (SchemaGrammar)vector.elementAt(n5);
                int n6 = 0;
                while (n6 < n2) {
                    if (schemaGrammar2 == this.fGrammarList[n6]) break;
                    ++n6;
                }
                if (n6 == n2) {
                    if (n2 == this.fGrammarList.length) {
                        String[] stringArray = new String[n2 * 2];
                        System.arraycopy(this.fNamespaces, 0, stringArray, 0, n2);
                        this.fNamespaces = stringArray;
                        SchemaGrammar[] schemaGrammarArray2 = new SchemaGrammar[n2 * 2];
                        System.arraycopy(this.fGrammarList, 0, schemaGrammarArray2, 0, n2);
                        this.fGrammarList = schemaGrammarArray2;
                    }
                    this.fNamespaces[n2] = schemaGrammar2.getTargetNamespace();
                    this.fGrammarList[n2] = schemaGrammar2;
                    ++n2;
                }
                --n5;
            }
            ++n4;
        }
        this.fGrammarMap = new SymbolHash(n2 * 2);
        n4 = 0;
        while (n4 < n2) {
            this.fGrammarMap.put(XSModelImpl.null2EmptyString(this.fNamespaces[n4]), this.fGrammarList[n4]);
            ++n4;
        }
        this.fGrammarCount = n2;
        this.fGlobalComponents = new XSNamedMap[15];
        this.fNSComponents = new XSNamedMap[n2][15];
        this.fTables = new SymbolHash[this.fGrammarCount];
    }

    public StringList getNamespaces() {
        return new StringListImpl(this.fNamespaces, this.fGrammarCount);
    }

    public XSNamespaceItemList getNamespaceItems() {
        return new NSItemListImpl(this.fGrammarList, this.fGrammarCount);
    }

    public synchronized XSNamedMap getComponents(short s2) {
        if (s2 <= 0 || s2 > 14 || !GLOBAL_COMP[s2]) {
            return null;
        }
        if (this.fGlobalComponents[s2] == null) {
            int n2 = 0;
            while (n2 < this.fGrammarCount) {
                switch (s2) {
                    case 3: 
                    case 13: 
                    case 14: {
                        this.fTables[n2] = this.fGrammarList[n2].fGlobalTypeDecls;
                        break;
                    }
                    case 1: {
                        this.fTables[n2] = this.fGrammarList[n2].fGlobalAttrDecls;
                        break;
                    }
                    case 2: {
                        this.fTables[n2] = this.fGrammarList[n2].fGlobalElemDecls;
                        break;
                    }
                    case 5: {
                        this.fTables[n2] = this.fGrammarList[n2].fGlobalAttrGrpDecls;
                        break;
                    }
                    case 6: {
                        this.fTables[n2] = this.fGrammarList[n2].fGlobalGroupDecls;
                        break;
                    }
                    case 11: {
                        this.fTables[n2] = this.fGrammarList[n2].fGlobalNotationDecls;
                    }
                }
                ++n2;
            }
            this.fGlobalComponents[s2] = s2 == 13 || s2 == 14 ? new XSNamedMap4Types(this.fNamespaces, this.fTables, this.fGrammarCount, s2) : new XSNamedMapImpl(this.fNamespaces, this.fTables, this.fGrammarCount);
        }
        return this.fGlobalComponents[s2];
    }

    public synchronized XSNamedMap getComponentsByNamespace(short s2, String string) {
        if (s2 <= 0 || s2 > 14 || !GLOBAL_COMP[s2]) {
            return null;
        }
        int n2 = 0;
        while (n2 < this.fGrammarCount) {
            if (this.fNamespaces[n2] == string) break;
            ++n2;
        }
        if (n2 == this.fGrammarCount) {
            return null;
        }
        if (this.fNSComponents[n2][s2] == null) {
            SymbolHash symbolHash = null;
            switch (s2) {
                case 3: 
                case 13: 
                case 14: {
                    symbolHash = this.fGrammarList[n2].fGlobalTypeDecls;
                    break;
                }
                case 1: {
                    symbolHash = this.fGrammarList[n2].fGlobalAttrDecls;
                    break;
                }
                case 2: {
                    symbolHash = this.fGrammarList[n2].fGlobalElemDecls;
                    break;
                }
                case 5: {
                    symbolHash = this.fGrammarList[n2].fGlobalAttrGrpDecls;
                    break;
                }
                case 6: {
                    symbolHash = this.fGrammarList[n2].fGlobalGroupDecls;
                    break;
                }
                case 11: {
                    symbolHash = this.fGrammarList[n2].fGlobalNotationDecls;
                }
            }
            this.fNSComponents[n2][s2] = s2 == 13 || s2 == 14 ? new XSNamedMap4Types(string, symbolHash, s2) : new XSNamedMapImpl(string, symbolHash);
        }
        return this.fNSComponents[n2][s2];
    }

    public XSTypeDefinition getTypeDefinition(String string, String string2) {
        SchemaGrammar schemaGrammar = (SchemaGrammar)this.fGrammarMap.get(XSModelImpl.null2EmptyString(string2));
        if (schemaGrammar == null) {
            return null;
        }
        return (XSTypeDefinition)schemaGrammar.fGlobalTypeDecls.get(string);
    }

    public XSAttributeDeclaration getAttributeDeclaration(String string, String string2) {
        SchemaGrammar schemaGrammar = (SchemaGrammar)this.fGrammarMap.get(XSModelImpl.null2EmptyString(string2));
        if (schemaGrammar == null) {
            return null;
        }
        return (XSAttributeDeclaration)schemaGrammar.fGlobalAttrDecls.get(string);
    }

    public XSElementDeclaration getElementDeclaration(String string, String string2) {
        SchemaGrammar schemaGrammar = (SchemaGrammar)this.fGrammarMap.get(XSModelImpl.null2EmptyString(string2));
        if (schemaGrammar == null) {
            return null;
        }
        return (XSElementDeclaration)schemaGrammar.fGlobalElemDecls.get(string);
    }

    public XSAttributeGroupDefinition getAttributeGroup(String string, String string2) {
        SchemaGrammar schemaGrammar = (SchemaGrammar)this.fGrammarMap.get(XSModelImpl.null2EmptyString(string2));
        if (schemaGrammar == null) {
            return null;
        }
        return (XSAttributeGroupDefinition)schemaGrammar.fGlobalAttrGrpDecls.get(string);
    }

    public XSModelGroupDefinition getModelGroupDefinition(String string, String string2) {
        SchemaGrammar schemaGrammar = (SchemaGrammar)this.fGrammarMap.get(XSModelImpl.null2EmptyString(string2));
        if (schemaGrammar == null) {
            return null;
        }
        return (XSModelGroupDefinition)schemaGrammar.fGlobalGroupDecls.get(string);
    }

    public XSNotationDeclaration getNotationDeclaration(String string, String string2) {
        SchemaGrammar schemaGrammar = (SchemaGrammar)this.fGrammarMap.get(XSModelImpl.null2EmptyString(string2));
        if (schemaGrammar == null) {
            return null;
        }
        return (XSNotationDeclaration)schemaGrammar.fGlobalNotationDecls.get(string);
    }

    public XSObjectList getAnnotations() {
        return null;
    }

    private static final String null2EmptyString(String string) {
        return string == null ? XMLSymbols.EMPTY_STRING : string;
    }
}

