/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs;

import org.apache.xerces.impl.dv.xs.TypeValidator;

public abstract class AbstractDateTimeDV
extends TypeValidator {
    private static final boolean DEBUG = false;
    protected static final int CY = 0;
    protected static final int M = 1;
    protected static final int D = 2;
    protected static final int h = 3;
    protected static final int m = 4;
    protected static final int s = 5;
    protected static final int ms = 6;
    protected static final int utc = 7;
    protected static final int hh = 0;
    protected static final int mm = 1;
    protected static final int TOTAL_SIZE = 8;
    protected static final int YEAR = 2000;
    protected static final int MONTH = 1;
    protected static final int DAY = 15;

    public short getAllowedFacets() {
        return 2552;
    }

    public int compare(Object object, Object object2) {
        return this.compareDates(((DateTimeData)object).data, ((DateTimeData)object2).data, true);
    }

    protected short compareDates(int[] nArray, int[] nArray2, boolean bl) {
        if (nArray[7] == nArray2[7]) {
            return this.compareOrder(nArray, nArray2);
        }
        int[] nArray3 = new int[8];
        int[] nArray4 = new int[2];
        if (nArray[7] == 90) {
            this.cloneDate(nArray2, nArray3);
            nArray4[0] = 14;
            nArray4[1] = 0;
            nArray3[7] = 43;
            this.normalize(nArray3, nArray4);
            short s2 = this.compareOrder(nArray, nArray3);
            this.cloneDate(nArray2, nArray3);
            nArray4[0] = 14;
            nArray4[1] = 0;
            nArray3[7] = 45;
            this.normalize(nArray3, nArray4);
            short s3 = this.compareOrder(nArray, nArray3);
            if (s2 < 0 && s3 > 0 || s2 == 0 && s3 == 0) {
                return 2;
            }
            return s2 != 2 ? s2 : s3;
        }
        if (nArray2[7] == 90) {
            this.cloneDate(nArray, nArray3);
            nArray4[0] = 14;
            nArray4[1] = 0;
            nArray3[7] = 45;
            this.normalize(nArray3, nArray4);
            short s4 = this.compareOrder(nArray3, nArray2);
            this.cloneDate(nArray, nArray3);
            nArray4[0] = 14;
            nArray4[1] = 0;
            nArray3[7] = 43;
            this.normalize(nArray3, nArray4);
            short s5 = this.compareOrder(nArray3, nArray2);
            if (s4 < 0 && s5 > 0 || s4 == 0 && s5 == 0) {
                return 2;
            }
            return s4 != 2 ? s4 : s5;
        }
        return 2;
    }

    protected short compareOrder(int[] nArray, int[] nArray2) {
        int n2 = 0;
        while (n2 < 8) {
            if (nArray[n2] < nArray2[n2]) {
                return -1;
            }
            if (nArray[n2] > nArray2[n2]) {
                return 1;
            }
            ++n2;
        }
        return 0;
    }

    protected void getTime(String string, int n2, int n3, int[] nArray, int[] nArray2) throws RuntimeException {
        int n4 = n2 + 2;
        nArray[3] = this.parseInt(string, n2, n4);
        if (string.charAt(n4++) != ':') {
            throw new RuntimeException("Error in parsing time zone");
        }
        n2 = n4;
        nArray[4] = this.parseInt(string, n2, n4 += 2);
        if (string.charAt(n4++) != ':') {
            throw new RuntimeException("Error in parsing time zone");
        }
        n2 = n4;
        nArray[5] = this.parseInt(string, n2, n4 += 2);
        int n5 = this.indexOf(string, n2, n3, '.');
        int n6 = this.findUTCSign(string, n5 != -1 ? n5 : n2, n3);
        if (n5 != -1) {
            nArray[6] = n6 < 0 ? this.parseInt(string, n5 + 1, string.length()) : this.parseInt(string, n5 + 1, n6);
        }
        if (n6 > 0) {
            this.getTimeZone(string, nArray, n6, n3, nArray2);
        }
    }

    protected int getDate(String string, int n2, int n3, int[] nArray) throws RuntimeException {
        n2 = this.getYearMonth(string, n2, n3, nArray);
        if (string.charAt(n2++) != '-') {
            throw new RuntimeException("CCYY-MM must be followed by '-' sign");
        }
        int n4 = n2 + 2;
        nArray[2] = this.parseInt(string, n2, n4);
        return n4;
    }

    protected int getYearMonth(String string, int n2, int n3, int[] nArray) throws RuntimeException {
        int n4;
        if (string.charAt(0) == '-') {
            ++n2;
        }
        if ((n4 = this.indexOf(string, n2, n3, '-')) == -1) {
            throw new RuntimeException("Year separator is missing or misplaced");
        }
        int n5 = n4 - n2;
        if (n5 < 4) {
            throw new RuntimeException("Year must have 'CCYY' format");
        }
        if (n5 > 4 && string.charAt(n2) == '0') {
            throw new RuntimeException("Leading zeros are required if the year value would otherwise have fewer than four digits; otherwise they are forbidden");
        }
        nArray[0] = this.parseIntYear(string, n4);
        if (string.charAt(n4) != '-') {
            throw new RuntimeException("CCYY must be followed by '-' sign");
        }
        n2 = ++n4;
        n4 = n2 + 2;
        nArray[1] = this.parseInt(string, n2, n4);
        return n4;
    }

    protected void parseTimeZone(String string, int n2, int n3, int[] nArray, int[] nArray2) throws RuntimeException {
        if (n2 < n3) {
            int n4 = this.findUTCSign(string, n2, n3);
            if (n4 < 0) {
                throw new RuntimeException("Error in month parsing");
            }
            this.getTimeZone(string, nArray, n4, n3, nArray2);
        }
    }

    protected void getTimeZone(String string, int[] nArray, int n2, int n3, int[] nArray2) throws RuntimeException {
        nArray[7] = string.charAt(n2);
        if (string.charAt(n2) == 'Z') {
            if (n3 > ++n2) {
                throw new RuntimeException("Error in parsing time zone");
            }
            return;
        }
        if (n2 <= n3 - 6) {
            int n4 = ++n2 + 2;
            nArray2[0] = this.parseInt(string, n2, n4);
            if (string.charAt(n4++) != ':') {
                throw new RuntimeException("Error in parsing time zone");
            }
            nArray2[1] = this.parseInt(string, n4, n4 + 2);
            if (n4 + 2 != n3) {
                throw new RuntimeException("Error in parsing time zone");
            }
        } else {
            throw new RuntimeException("Error in parsing time zone");
        }
    }

    protected int indexOf(String string, int n2, int n3, char c2) {
        int n4 = n2;
        while (n4 < n3) {
            if (string.charAt(n4) == c2) {
                return n4;
            }
            ++n4;
        }
        return -1;
    }

    protected void validateDateTime(int[] nArray, int[] nArray2) {
        if (nArray[0] == 0) {
            throw new RuntimeException("The year \"0000\" is an illegal year value");
        }
        if (nArray[1] < 1 || nArray[1] > 12) {
            throw new RuntimeException("The month must have values 1 to 12");
        }
        if (nArray[2] > this.maxDayInMonthFor(nArray[0], nArray[1]) || nArray[2] < 1) {
            throw new RuntimeException("The day must have values 1 to 31");
        }
        if (nArray[3] > 23 || nArray[3] < 0) {
            throw new RuntimeException("Hour must have values 0-23");
        }
        if (nArray[4] > 59 || nArray[4] < 0) {
            throw new RuntimeException("Minute must have values 0-59");
        }
        if (nArray[5] > 60 || nArray[5] < 0) {
            throw new RuntimeException("Second must have values 0-60");
        }
        if (nArray2[0] > 14 || nArray2[0] < -14) {
            throw new RuntimeException("Time zone should have range -14..+14");
        }
        if (nArray2[1] > 59 || nArray2[1] < -59) {
            throw new RuntimeException("Minute must have values 0-59");
        }
    }

    protected int findUTCSign(String string, int n2, int n3) {
        int n4 = n2;
        while (n4 < n3) {
            char c2 = string.charAt(n4);
            if (c2 == 'Z' || c2 == '+' || c2 == '-') {
                return n4;
            }
            ++n4;
        }
        return -1;
    }

    protected int parseInt(String string, int n2, int n3) throws NumberFormatException {
        int n4 = 10;
        int n5 = 0;
        int n6 = 0;
        int n7 = -2147483647;
        int n8 = n7 / n4;
        int n9 = n2;
        do {
            if ((n6 = TypeValidator.getDigit(string.charAt(n9))) < 0) {
                throw new NumberFormatException("'" + string.toString() + "' has wrong format");
            }
            if (n5 < n8) {
                throw new NumberFormatException("'" + string.toString() + "' has wrong format");
            }
            if ((n5 *= n4) < n7 + n6) {
                throw new NumberFormatException("'" + string.toString() + "' has wrong format");
            }
            n5 -= n6;
        } while (++n9 < n3);
        return -n5;
    }

    protected int parseIntYear(String string, int n2) {
        int n3;
        int n4 = 10;
        int n5 = 0;
        boolean bl = false;
        int n6 = 0;
        int n7 = 0;
        if (string.charAt(0) == '-') {
            bl = true;
            n3 = Integer.MIN_VALUE;
            ++n6;
        } else {
            n3 = -2147483647;
        }
        int n8 = n3 / n4;
        while (n6 < n2) {
            if ((n7 = TypeValidator.getDigit(string.charAt(n6++))) < 0) {
                throw new NumberFormatException("'" + string.toString() + "' has wrong format");
            }
            if (n5 < n8) {
                throw new NumberFormatException("'" + string.toString() + "' has wrong format");
            }
            if ((n5 *= n4) < n3 + n7) {
                throw new NumberFormatException("'" + string.toString() + "' has wrong format");
            }
            n5 -= n7;
        }
        if (bl) {
            if (n6 > 1) {
                return n5;
            }
            throw new NumberFormatException("'" + string.toString() + "' has wrong format");
        }
        return -n5;
    }

    protected void normalize(int[] nArray, int[] nArray2) {
        int n2 = 1;
        if (nArray[7] == 43) {
            n2 = -1;
        }
        int n3 = nArray[4] + n2 * nArray2[1];
        int n4 = this.fQuotient(n3, 60);
        nArray[4] = this.mod(n3, 60, n4);
        n3 = nArray[3] + n2 * nArray2[0] + n4;
        n4 = this.fQuotient(n3, 24);
        nArray[3] = this.mod(n3, 24, n4);
        nArray[2] = nArray[2] + n4;
        while (true) {
            n3 = this.maxDayInMonthFor(nArray[0], nArray[1]);
            if (nArray[2] < 1) {
                nArray[2] = nArray[2] + this.maxDayInMonthFor(nArray[0], nArray[1] - 1);
                n4 = -1;
            } else {
                if (nArray[2] <= n3) break;
                nArray[2] = nArray[2] - n3;
                n4 = 1;
            }
            n3 = nArray[1] + n4;
            nArray[1] = this.modulo(n3, 1, 13);
            nArray[0] = nArray[0] + this.fQuotient(n3, 1, 13);
        }
        nArray[7] = 90;
    }

    protected void resetDateObj(int[] nArray) {
        int n2 = 0;
        while (n2 < 8) {
            nArray[n2] = 0;
            ++n2;
        }
    }

    protected int maxDayInMonthFor(int n2, int n3) {
        if (n3 == 4 || n3 == 6 || n3 == 9 || n3 == 11) {
            return 30;
        }
        if (n3 == 2) {
            if (this.isLeapYear(n2)) {
                return 29;
            }
            return 28;
        }
        return 31;
    }

    private boolean isLeapYear(int n2) {
        return n2 % 4 == 0 && (n2 % 100 != 0 || n2 % 400 == 0);
    }

    protected int mod(int n2, int n3, int n4) {
        return n2 - n4 * n3;
    }

    protected int fQuotient(int n2, int n3) {
        return (int)Math.floor((float)n2 / (float)n3);
    }

    protected int modulo(int n2, int n3, int n4) {
        int n5 = n2 - n3;
        int n6 = n4 - n3;
        return this.mod(n5, n6, this.fQuotient(n5, n6)) + n3;
    }

    protected int fQuotient(int n2, int n3, int n4) {
        return this.fQuotient(n2 - n3, n4 - n3);
    }

    protected String dateToString(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer(25);
        this.append(stringBuffer, nArray[0], 4);
        stringBuffer.append('-');
        this.append(stringBuffer, nArray[1], 2);
        stringBuffer.append('-');
        this.append(stringBuffer, nArray[2], 2);
        stringBuffer.append('T');
        this.append(stringBuffer, nArray[3], 2);
        stringBuffer.append(':');
        this.append(stringBuffer, nArray[4], 2);
        stringBuffer.append(':');
        this.append(stringBuffer, nArray[5], 2);
        stringBuffer.append('.');
        stringBuffer.append(nArray[6]);
        this.append(stringBuffer, (char)nArray[7], 0);
        return stringBuffer.toString();
    }

    protected void append(StringBuffer stringBuffer, int n2, int n3) {
        if (n2 < 0) {
            stringBuffer.append('-');
            n2 = -n2;
        }
        if (n3 == 4) {
            if (n2 < 10) {
                stringBuffer.append("000");
            } else if (n2 < 100) {
                stringBuffer.append("00");
            } else if (n2 < 1000) {
                stringBuffer.append("0");
            }
            stringBuffer.append(n2);
        } else if (n3 == 2) {
            if (n2 < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(n2);
        } else if (n2 != 0) {
            stringBuffer.append((char)n2);
        }
    }

    private void cloneDate(int[] nArray, int[] nArray2) {
        System.arraycopy(nArray, 0, nArray2, 0, 8);
    }

    static final class DateTimeData {
        final int[] data;
        final AbstractDateTimeDV type;
        private String canonical;

        public DateTimeData(int[] nArray, AbstractDateTimeDV abstractDateTimeDV) {
            this.data = nArray;
            this.type = abstractDateTimeDV;
        }

        public boolean equals(Object object) {
            if (!(object instanceof DateTimeData)) {
                return false;
            }
            int[] nArray = ((DateTimeData)object).data;
            return this.type.compareDates(this.data, nArray, true) == 0;
        }

        public synchronized String toString() {
            if (this.canonical == null) {
                this.canonical = this.type.dateToString(this.data);
            }
            return this.canonical;
        }
    }
}

