/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim25.mo;

import com.vmware.vim25.ConcurrentAccess;
import com.vmware.vim25.DuplicateName;
import com.vmware.vim25.FileFault;
import com.vmware.vim25.InsufficientResourcesFault;
import com.vmware.vim25.InvalidDatastore;
import com.vmware.vim25.InvalidName;
import com.vmware.vim25.InvalidPowerState;
import com.vmware.vim25.InvalidState;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.MigrationFault;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.TaskInProgress;
import com.vmware.vim25.VAppCloneSpec;
import com.vmware.vim25.VAppConfigFault;
import com.vmware.vim25.VAppConfigInfo;
import com.vmware.vim25.VAppConfigSpec;
import com.vmware.vim25.VirtualAppLinkInfo;
import com.vmware.vim25.VirtualAppSummary;
import com.vmware.vim25.VmConfigFault;
import com.vmware.vim25.mo.Datastore;
import com.vmware.vim25.mo.Folder;
import com.vmware.vim25.mo.HttpNfcLease;
import com.vmware.vim25.mo.ManagedEntity;
import com.vmware.vim25.mo.Network;
import com.vmware.vim25.mo.ResourcePool;
import com.vmware.vim25.mo.ServerConnection;
import com.vmware.vim25.mo.Task;
import java.rmi.RemoteException;

public class VirtualApp
extends ResourcePool {
    public VirtualApp(ServerConnection sc, ManagedObjectReference mor) {
        super(sc, mor);
    }

    public VirtualAppLinkInfo[] getChildLink() {
        return (VirtualAppLinkInfo[])this.getCurrentProperty("childLink");
    }

    public Datastore[] getDatastore() {
        return this.getDatastores("datastore");
    }

    public Network[] getNetwork() {
        return this.getNetworks("network");
    }

    public VirtualAppSummary getSummary() {
        return (VirtualAppSummary)this.getCurrentProperty("summary");
    }

    public Folder getParentFolder() {
        ManagedObjectReference mor = (ManagedObjectReference)this.getCurrentProperty("parentFolder");
        return new Folder(this.getServerConnection(), mor);
    }

    public ManagedEntity getParentVApp() {
        ManagedObjectReference mor = (ManagedObjectReference)this.getCurrentProperty("parentVApp");
        return new ManagedEntity(this.getServerConnection(), mor);
    }

    public VAppConfigInfo getVAppConfig() {
        return (VAppConfigInfo)this.getCurrentProperty("vAppConfig");
    }

    public Task cloneVApp_Task(String name, ManagedObjectReference target, VAppCloneSpec spec) throws InvalidState, InvalidDatastore, TaskInProgress, VmConfigFault, FileFault, MigrationFault, InsufficientResourcesFault, RuntimeFault, RemoteException {
        ManagedObjectReference taskMor = this.getVimService().cloneVApp_Task(this.getMOR(), name, target, spec);
        return new Task(this.getServerConnection(), taskMor);
    }

    public HttpNfcLease exportVApp() throws InvalidPowerState, TaskInProgress, InvalidState, FileFault, RuntimeFault, RemoteException {
        ManagedObjectReference mor = this.getVimService().exportVApp(this.getMOR());
        return new HttpNfcLease(this.getServerConnection(), mor);
    }

    public Task powerOffVApp_Task(boolean force) throws TaskInProgress, InvalidState, VAppConfigFault, RuntimeFault, RemoteException {
        ManagedObjectReference taskMor = this.getVimService().powerOffVApp_Task(this.getMOR(), force);
        return new Task(this.getServerConnection(), taskMor);
    }

    public Task suspendVApp_Task() throws TaskInProgress, InvalidState, VAppConfigFault, RuntimeFault, RemoteException {
        ManagedObjectReference taskMor = this.getVimService().suspendVApp_Task(this.getMOR());
        return new Task(this.getServerConnection(), taskMor);
    }

    public Task powerOnVApp_Task() throws TaskInProgress, InvalidState, InsufficientResourcesFault, VmConfigFault, VAppConfigFault, FileFault, RuntimeFault, RemoteException {
        ManagedObjectReference taskMor = this.getVimService().powerOnVApp_Task(this.getMOR());
        return new Task(this.getServerConnection(), taskMor);
    }

    public Task unregisterVApp_Task() throws ConcurrentAccess, InvalidState, RuntimeFault, RemoteException {
        ManagedObjectReference taskMor = this.getVimService().unregisterVApp_Task(this.getMOR());
        return new Task(this.getServerConnection(), taskMor);
    }

    public void updateLinkedChildren(VirtualAppLinkInfo[] addChangeSet, ManagedObjectReference[] removeSet) throws ConcurrentAccess, RuntimeFault, RemoteException {
        this.getVimService().updateLinkedChildren(this.getMOR(), addChangeSet, removeSet);
    }

    public void updateVAppConfig(VAppConfigSpec spec) throws TaskInProgress, VmConfigFault, ConcurrentAccess, FileFault, InvalidName, DuplicateName, InvalidState, InsufficientResourcesFault, InvalidDatastore, RuntimeFault, RemoteException {
        this.getVimService().updateVAppConfig(this.getMOR(), spec);
    }
}

