/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.X509TrustManager;
import com.sun.net.ssl.internal.ssl.CipherSpec;
import com.sun.net.ssl.internal.ssl.ClientDiffieHellmanPublic;
import com.sun.net.ssl.internal.ssl.Debug;
import com.sun.net.ssl.internal.ssl.HandshakeMessage;
import com.sun.net.ssl.internal.ssl.Handshaker;
import com.sun.net.ssl.internal.ssl.JsseX509TrustManager;
import com.sun.net.ssl.internal.ssl.SSLContextImpl;
import com.sun.net.ssl.internal.ssl.SSLSessionImpl;
import com.sun.net.ssl.internal.ssl.SSLSocketImpl;
import com.sun.net.ssl.internal.ssl.SunJSSE_am;
import com.sun.net.ssl.internal.ssl.SunJSSE_h;
import com.sun.net.ssl.internal.ssl.SunJSSE_i;
import com.sun.net.ssl.internal.ssl.SunJSSE_j;
import com.sun.net.ssl.internal.ssl.SunJSSE_l;
import com.sun.net.ssl.internal.ssl.SunJSSE_n;
import com.sun.net.ssl.internal.ssl.SunJSSE_o;
import com.sun.net.ssl.internal.ssl.SunJSSE_p;
import com.sun.net.ssl.internal.ssl.SunJSSE_u;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLProtocolException;

final class ClientHandshaker
extends Handshaker {
    private PublicKey a;
    private byte[] b;
    private BigInteger c;
    private SunJSSE_u d;
    private SunJSSE_n e;
    private boolean f;

    ClientHandshaker(SSLSocketImpl sSLSocketImpl) throws NoSuchAlgorithmException {
        this(sSLSocketImpl, null);
    }

    ClientHandshaker(SSLSocketImpl sSLSocketImpl, SSLContextImpl sSLContextImpl) throws NoSuchAlgorithmException {
        super(sSLSocketImpl, sSLContextImpl, true);
    }

    boolean a(int n2, boolean bl) {
        switch (n2) {
            case 1: 
            case 2: 
            case 5: {
                return true;
            }
            case 6: {
                return true;
            }
            case 7: {
                return true;
            }
        }
        return false;
    }

    protected boolean canUseCipherSuite(String string) {
        return this.isEnabled(string);
    }

    private int a(SunJSSE_i sunJSSE_i, int n2, int n3, int n4, String string) {
        if (this.isEnabled(string)) {
            sunJSSE_i.e[n4++] = (byte)n2;
            sunJSSE_i.e[n4++] = (byte)n3;
        }
        return n4;
    }

    private void a(BigInteger bigInteger, BigInteger bigInteger2) {
        this.d = new SunJSSE_u(bigInteger, bigInteger2);
        this.d.a(this.g.e(), 768);
    }

    protected HandshakeMessage getKickstartMessage() throws SSLException {
        SunJSSE_i sunJSSE_i = new SunJSSE_i(this.g.e());
        int n2 = 0;
        this.h = sunJSSE_i.c;
        this.j = this.g.c().a(((Handshaker)this).a.e());
        if (Handshaker.m != null && Debug.isOn("session")) {
            if (this.j != null) {
                System.out.println("%% Client cached " + this.j + (this.j.e() ? "" : " (not rejoinable)"));
            } else {
                System.out.println("%% No cached client session");
            }
        }
        if (this.j != null) {
            CipherSpec cipherSpec;
            if (!this.isEnabled(this.j.getCipherSuite())) {
                if (Handshaker.m != null && Debug.isOn("session")) {
                    System.out.println("%% can't resume, cipher disabled");
                }
                this.j = null;
            }
            if (this.j != null) {
                if (Handshaker.m != null && (Debug.isOn("handshake") || Debug.isOn("session"))) {
                    System.out.println("%% Try resuming " + this.j + " from port " + ((Handshaker)this).a.getLocalPort());
                }
                sunJSSE_i.d = this.j.d();
                cipherSpec = this.j.a();
                ((CipherSpec)this).a = sunJSSE_i.a = cipherSpec.a;
                ((CipherSpec)this).b = sunJSSE_i.b = cipherSpec.b;
                ((Handshaker)this).a.a(((CipherSpec)this).a, ((CipherSpec)this).b);
                ((Handshaker)this).e.r.a(((CipherSpec)this).a, ((CipherSpec)this).b);
            }
            if (!this.l) {
                if (this.j == null) {
                    throw new SSLException("Can't reuse existing SSL client session");
                }
                cipherSpec = this.j.a();
                sunJSSE_i.e = cipherSpec.getCipherSuite();
                return sunJSSE_i;
            }
        }
        if (this.j == null) {
            if (this.l) {
                sunJSSE_i.d = SSLSessionImpl.a.d();
            } else {
                throw new SSLException("No existing session to resume.");
            }
        }
        sunJSSE_i.e = new byte[2 * this.ak.length];
        n2 = this.a(sunJSSE_i, 0, 5, n2, "SSL_RSA_WITH_RC4_128_SHA");
        n2 = this.a(sunJSSE_i, 0, 4, n2, "SSL_RSA_WITH_RC4_128_MD5");
        n2 = this.a(sunJSSE_i, 0, 9, n2, "SSL_RSA_WITH_DES_CBC_SHA");
        n2 = this.a(sunJSSE_i, 0, 10, n2, "SSL_RSA_WITH_3DES_EDE_CBC_SHA");
        n2 = this.a(sunJSSE_i, 0, 18, n2, "SSL_DHE_DSS_WITH_DES_CBC_SHA");
        n2 = this.a(sunJSSE_i, 0, 19, n2, "SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA");
        n2 = this.a(sunJSSE_i, 0, 3, n2, "SSL_RSA_EXPORT_WITH_RC4_40_MD5");
        n2 = this.a(sunJSSE_i, 0, 17, n2, "SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA");
        n2 = this.a(sunJSSE_i, 0, 2, n2, "SSL_RSA_WITH_NULL_SHA");
        n2 = this.a(sunJSSE_i, 0, 1, n2, "SSL_RSA_WITH_NULL_MD5");
        n2 = this.a(sunJSSE_i, 0, 24, n2, "SSL_DH_anon_WITH_RC4_128_MD5");
        n2 = this.a(sunJSSE_i, 0, 26, n2, "SSL_DH_anon_WITH_DES_CBC_SHA");
        n2 = this.a(sunJSSE_i, 0, 27, n2, "SSL_DH_anon_WITH_3DES_EDE_CBC_SHA");
        n2 = this.a(sunJSSE_i, 0, 23, n2, "SSL_DH_anon_EXPORT_WITH_RC4_40_MD5");
        n2 = this.a(sunJSSE_i, 0, 25, n2, "SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA");
        return sunJSSE_i;
    }

    void a(byte by) throws SSLProtocolException {
        String string = SSLSocketImpl.a(by);
        if (Handshaker.m != null && Debug.isOn("handshake")) {
            System.out.println("SSL - handshake alert: " + string);
        }
        throw new SSLProtocolException("handshake alert:  " + string);
    }

    protected void processMessage(byte by, int n2) throws IOException, NoSuchAlgorithmException {
        if (((Handshaker)this).f > by && by != 0 && ((Handshaker)this).f != 1) {
            throw new SSLProtocolException("Handshake message sequence violation, " + by);
        }
        block2 : switch (by) {
            case 0: {
                this.a(new SunJSSE_h(((Handshaker)this).d));
                break;
            }
            case 2: {
                this.a(new SunJSSE_j(((Handshaker)this).d));
                break;
            }
            case 11: {
                if (this.o == 7) {
                    ((Handshaker)this).a.a((byte)10, "unexpected server cert chain");
                }
                this.a(new HandshakeMessage.CertificateMsg(((Handshaker)this).d));
                this.a = this.j.getPeerCertificateChain()[0].getPublicKey();
                break;
            }
            case 12: {
                this.f = true;
                switch (this.o) {
                    case 1: 
                    case 2: {
                        try {
                            this.a(new SunJSSE_l(((Handshaker)this).d, n2));
                            break block2;
                        }
                        catch (SignatureException signatureException) {
                            throw new SSLException("Server key, " + signatureException);
                        }
                        catch (InvalidKeyException invalidKeyException) {
                            throw new SSLException("Server key, " + invalidKeyException);
                        }
                    }
                    case 7: {
                        this.a(new HandshakeMessage.DH_ServerKeyExchange(((Handshaker)this).d));
                        break block2;
                    }
                    case 5: 
                    case 6: {
                        try {
                            this.a(new HandshakeMessage.DH_ServerKeyExchange(((Handshaker)this).d, this.a, this.h.a, this.i.a, n2));
                            break block2;
                        }
                        catch (SignatureException signatureException) {
                            throw new SSLException("Server key, " + signatureException);
                        }
                        catch (InvalidKeyException invalidKeyException) {
                            throw new SSLException("Server key, " + invalidKeyException);
                        }
                    }
                }
                throw new SSLProtocolException("unsupported key exchange algorithm = " + this.o);
            }
            case 13: {
                this.e = new SunJSSE_n(((Handshaker)this).d);
                if (Handshaker.m == null || !Debug.isOn("handshake")) break;
                this.e.a(System.out);
                break;
            }
            case 14: {
                this.a(new SunJSSE_o(((Handshaker)this).d));
                break;
            }
            case 20: {
                this.a(new HandshakeMessage.Finished(((CipherSpec)this).a, ((CipherSpec)this).b, ((Handshaker)this).d));
                break;
            }
            default: {
                throw new SSLProtocolException("Illegal client handshake msg, " + by);
            }
        }
        if (((Handshaker)this).f < by) {
            ((Handshaker)this).f = by;
        }
    }

    private void c() throws IOException {
        HandshakeMessage.Finished finished;
        try {
            if (((Handshaker)this).b[0] == null) {
                throw new CloneNotSupportedException("minor hack");
            }
            finished = ((CipherSpec)this).b == 0 ? new HandshakeMessage.Finished(((CipherSpec)this).a, ((CipherSpec)this).b, (MessageDigest)((Handshaker)this).b[0].clone(), (MessageDigest)((Handshaker)this).c[0].clone(), HandshakeMessage.Finished.c, this.j.c()) : new HandshakeMessage.Finished(((CipherSpec)this).a, ((CipherSpec)this).b, (MessageDigest)((Handshaker)this).b[0].clone(), (MessageDigest)((Handshaker)this).c[0].clone(), "client finished", this.j.c());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            finished = ((CipherSpec)this).b == 0 ? new HandshakeMessage.Finished(((CipherSpec)this).a, ((CipherSpec)this).b, ((Handshaker)this).b[1], ((Handshaker)this).c[1], HandshakeMessage.Finished.c, this.j.c()) : new HandshakeMessage.Finished(((CipherSpec)this).a, ((CipherSpec)this).b, ((Handshaker)this).b[1], ((Handshaker)this).c[1], "client finished", this.j.c());
            ((Handshaker)this).b[1] = null;
            ((Handshaker)this).c[1] = null;
        }
        this.sendChangeCipherSpec(finished);
        ((Handshaker)this).f = 19;
    }

    private void a(HandshakeMessage.CertificateMsg certificateMsg) throws IOException {
        boolean bl;
        X509TrustManager x509TrustManager;
        X509Certificate[] x509CertificateArray;
        if (Handshaker.m != null && Debug.isOn("handshake")) {
            certificateMsg.a(System.out);
        }
        if ((x509CertificateArray = certificateMsg.getCertificateChain()).length == 0) {
            ((Handshaker)this).a.a((byte)42, "null cert chain");
        }
        if ((x509TrustManager = this.g.h()) instanceof JsseX509TrustManager) {
            String string = this.j.getCipherSuite();
            String string2 = string.substring(string.indexOf(95) + 1, string.indexOf("_WITH"));
            if (string2.startsWith("RSA_EXPORT") && !this.f) {
                string2 = "RSA";
            }
            bl = ((JsseX509TrustManager)x509TrustManager).isServerTrusted(x509CertificateArray, string2);
        } else {
            bl = x509TrustManager.isServerTrusted(x509CertificateArray);
        }
        if (bl) {
            this.j.a(x509CertificateArray);
        } else {
            ((Handshaker)this).a.a((byte)46, "untrusted server cert chain");
        }
    }

    private void a(HandshakeMessage.Finished finished) throws IOException {
        if (Handshaker.m != null && Debug.isOn("handshake")) {
            finished.a(System.out);
        }
        boolean bl = false;
        try {
            bl = ((CipherSpec)this).b == 0 ? finished.verify((MessageDigest)((Handshaker)this).b[0].clone(), (MessageDigest)((Handshaker)this).c[0].clone(), HandshakeMessage.Finished.d, this.j.c()) : finished.verify((MessageDigest)((Handshaker)this).b[0].clone(), (MessageDigest)((Handshaker)this).c[0].clone(), "server finished", this.j.c());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            bl = ((CipherSpec)this).b == 0 ? finished.verify(((Handshaker)this).b[0], ((Handshaker)this).c[0], HandshakeMessage.Finished.d, this.j.c()) : finished.verify(((Handshaker)this).b[0], ((Handshaker)this).c[0], "server finished", this.j.c());
            ((Handshaker)this).b[0] = null;
            ((Handshaker)this).c[0] = null;
        }
        if (!bl) {
            ((Handshaker)this).a.a((byte)47, "server 'finished' message doesn't verify");
        }
        if (this.k) {
            ((Handshaker)this).d.digestNow();
            this.c();
        }
        if (((Handshaker)this).a.c() && this.j.e()) {
            this.g.c().a(this.j);
            if (Handshaker.m != null && Debug.isOn("session")) {
                System.out.println("%% Cached client session: " + this.j);
            }
        } else if (Handshaker.m != null && Debug.isOn("session")) {
            System.out.println("%% Didn't cache non-resumable client session: " + this.j);
        }
    }

    private void a(SunJSSE_j sunJSSE_j) throws IOException {
        this.f = false;
        if (Handshaker.m != null && Debug.isOn("handshake")) {
            sunJSSE_j.a(System.out);
        }
        if (sunJSSE_j.a != 3 || sunJSSE_j.b > 1) {
            throw new SSLProtocolException("version mismatch, server is v" + sunJSSE_j.a + "." + sunJSSE_j.b);
        }
        ((CipherSpec)this).a = sunJSSE_j.a;
        ((CipherSpec)this).b = sunJSSE_j.b;
        ((Handshaker)this).a.a(((CipherSpec)this).a, ((CipherSpec)this).b);
        ((Handshaker)this).e.r.a(((CipherSpec)this).a, ((CipherSpec)this).b);
        this.i = sunJSSE_j.c;
        if (this.j != null) {
            if (this.j.d().equals(sunJSSE_j.d)) {
                CipherSpec cipherSpec = this.j.a();
                byte[] byArray = cipherSpec.getCipherSuite();
                if (sunJSSE_j.e[0] != byArray[0] || sunJSSE_j.e[1] != byArray[1] || sunJSSE_j.a != cipherSpec.a || sunJSSE_j.b != cipherSpec.b) {
                    throw new SSLProtocolException("Server returned wrong cipher suite for session");
                }
                this.k = true;
                ((Handshaker)this).f = 19;
                if (Handshaker.m != null && Debug.isOn("session")) {
                    System.out.println("%% Server resumed " + this.j);
                }
            } else {
                this.j = null;
                if (!this.l) {
                    throw new SSLException("New session creation was disabled");
                }
            }
        }
        if (!this.c(sunJSSE_j.e[0], sunJSSE_j.e[1])) {
            ((Handshaker)this).a.a((byte)47, "Can't support cipher suite [" + sunJSSE_j.e[0] + ", " + sunJSSE_j.e[1] + "]");
        } else if (sunJSSE_j.f != 0) {
            ((Handshaker)this).a.a((byte)47, "compression type not supported, " + sunJSSE_j.f);
        }
        if (this.j == null) {
            this.j = new SSLSessionImpl((CipherSpec)this, sunJSSE_j.d, ((Handshaker)this).a.e(), ((Handshaker)this).a.getPort());
            if (Handshaker.m != null && Debug.isOn("handshake")) {
                System.out.println("** " + this.j.a());
            }
        } else {
            try {
                this.a(this.j.c());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new SSLException("Missing algorithm: " + noSuchAlgorithmException.getMessage());
            }
        }
    }

    private void a(SunJSSE_o sunJSSE_o) throws IOException, NoSuchAlgorithmException {
        Object object;
        Object object2;
        Object object3;
        if (Handshaker.m != null && Debug.isOn("handshake")) {
            sunJSSE_o.a(System.out);
        }
        ((Handshaker)this).d.digestNow();
        PrivateKey privateKey = null;
        if (this.e != null) {
            object3 = this.g.g();
            object2 = null;
            HandshakeMessage.CertificateMsg certificateMsg = null;
            int n2 = 0;
            while (n2 < this.e.g.length) {
                object = null;
                switch (this.e.g[n2]) {
                    case 1: {
                        object = "RSA";
                        break;
                    }
                    case 2: {
                        object = "DSA";
                        break;
                    }
                    case 3: {
                        object = "DH_RSA";
                        break;
                    }
                    case 4: {
                        object = "DH_DSA";
                        break;
                    }
                    default: {
                        object = null;
                    }
                }
                if (object != null && (object2 = object3.chooseClientAlias((String)object, this.e.a())) != null) break;
                ++n2;
            }
            if (object2 != null) {
                certificateMsg = new HandshakeMessage.CertificateMsg(object3.getCertificateChain((String)object2));
                privateKey = object3.getPrivateKey((String)object2);
                this.j.a(true);
            } else if (((CipherSpec)this).b > 0) {
                certificateMsg = new HandshakeMessage.CertificateMsg(new X509Certificate[0]);
            } else {
                ((Handshaker)this).a.b((byte)41);
            }
            if (certificateMsg != null) {
                if (Handshaker.m != null && Debug.isOn("handshake")) {
                    certificateMsg.a(System.out);
                }
                certificateMsg.write(((Handshaker)this).e);
            }
        }
        switch (this.o) {
            case 1: 
            case 2: {
                object2 = new SunJSSE_am(((CipherSpec)this).a, ((CipherSpec)this).b, this.g.e(), this.a);
                this.b = ((SunJSSE_am)object2).e;
                object3 = object2;
                break;
            }
            case 3: 
            case 4: {
                object3 = new ClientDiffieHellmanPublic();
                break;
            }
            case 6: 
            case 7: {
                object3 = new ClientDiffieHellmanPublic(this.d.d());
                break;
            }
            default: {
                throw new SSLProtocolException("unsupported key exchange algorithm = " + this.o);
            }
        }
        if (Handshaker.m != null && Debug.isOn("handshake")) {
            ((HandshakeMessage)object3).a(System.out);
        }
        ((HandshakeMessage)object3).write(((Handshaker)this).e);
        ((Handshaker)this).e.a();
        ((Handshaker)this).e.flush();
        switch (this.o) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.b = this.d.a(this.c);
                break;
            }
            default: {
                throw new SSLProtocolException("unsupported key exchange algorithm = " + this.o);
            }
            case 1: 
            case 2: 
        }
        this.b(this.b);
        int n3 = 0;
        while (n3 < this.b.length) {
            this.b[n3] = 0;
            ++n3;
        }
        if (privateKey != null) {
            MessageDigest messageDigest;
            HandshakeMessage handshakeMessage = null;
            try {
                object = (MessageDigest)((Handshaker)this).b[0].clone();
                messageDigest = (MessageDigest)((Handshaker)this).c[0].clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                object = ((Handshaker)this).b[2];
                messageDigest = ((Handshaker)this).c[2];
                ((Handshaker)this).b[2] = null;
                ((Handshaker)this).c[2] = null;
            }
            try {
                handshakeMessage = privateKey instanceof RSAPrivateKey ? new SunJSSE_p(((CipherSpec)this).b, (RSAPrivateKey)privateKey, (MessageDigest)object, messageDigest, this.j.c(), this.g.e()) : new SunJSSE_p(((CipherSpec)this).b, privateKey, messageDigest, this.j.c(), this.g.e());
            }
            catch (InvalidKeyException invalidKeyException) {
                ((Handshaker)this).a.a((byte)40, "Invalid private key");
            }
            catch (SignatureException signatureException) {
                ((Handshaker)this).a.a((byte)40, "DSS/DSA signature failure");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                ((Handshaker)this).a.a((byte)40, "No DSS/DSA implementation");
            }
            if (Handshaker.m != null && Debug.isOn("handshake")) {
                ((SunJSSE_p)handshakeMessage).a(System.out);
            }
            handshakeMessage.write(((Handshaker)this).e);
            ((Handshaker)this).e.a();
        }
        this.c();
    }

    private void a(SunJSSE_h sunJSSE_h) throws IOException {
        if (Handshaker.m != null && Debug.isOn("handshake")) {
            sunJSSE_h.a(System.out);
        }
        if (((Handshaker)this).f < 1) {
            this.kickstart();
        }
    }

    private void a(HandshakeMessage.DH_ServerKeyExchange dH_ServerKeyExchange) throws IOException, NoSuchAlgorithmException {
        if (Handshaker.m != null && Debug.isOn("handshake")) {
            dH_ServerKeyExchange.a(System.out);
        }
        if (this.o == 4 || this.o == 3) {
            ((Handshaker)this).a.a((byte)10, "not supporting DH certs for key exchange now");
        }
        this.a(dH_ServerKeyExchange.getModulus(), dH_ServerKeyExchange.getBase());
        this.c = dH_ServerKeyExchange.getServerPublicKey();
    }

    private void a(SunJSSE_l sunJSSE_l) throws IOException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        if (Handshaker.m != null && Debug.isOn("handshake")) {
            sunJSSE_l.a(System.out);
        }
        if (!(this.a instanceof RSAPublicKey)) {
            throw new InvalidKeyException("server key not an RSA key");
        }
        if (!sunJSSE_l.a((RSAPublicKey)this.a, this.h, this.i)) {
            ((Handshaker)this).a.a((byte)40, "server key exchange invalid");
        }
        this.a = sunJSSE_l.a();
    }
}

