/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.DerEncoder;
import com.sun.net.ssl.internal.ssl.DerInputStream;
import com.sun.net.ssl.internal.ssl.DerOutputStream;
import com.sun.net.ssl.internal.ssl.DerValue;
import com.sun.net.ssl.internal.ssl.ObjectIdentifier;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.AlgorithmParameters;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class AlgorithmId
implements Serializable,
DerEncoder {
    private static final long serialVersionUID = 7205873507486557157L;
    private static boolean a = false;
    private static Hashtable b;
    private ObjectIdentifier c;
    private AlgorithmParameters d;
    protected DerValue params;
    private static final int[] e;
    private static final int[] f;
    private static final int[] g;
    public static final ObjectIdentifier MD2_oid;
    public static final ObjectIdentifier MD5_oid;
    public static final ObjectIdentifier SHA_oid;
    private static final int[] h;
    private static final int[] i;
    private static final int[] j;
    private static final int[] k;
    private static final int[] l;
    private static final int[] m;
    public static final ObjectIdentifier DH_oid;
    public static final ObjectIdentifier DH_PKIX_oid;
    public static final ObjectIdentifier DSA_OIW_oid;
    public static final ObjectIdentifier DSA_oid;
    public static final ObjectIdentifier RSA_oid;
    public static final ObjectIdentifier RSAEncryption_oid;
    private static final int[] n;
    private static final int[] o;
    private static final int[] p;
    private static final int[] q;
    private static final int[] r;
    private static final int[] s;
    private static final int[] t;
    public static final ObjectIdentifier md2WithRSAEncryption_oid;
    public static final ObjectIdentifier md5WithRSAEncryption_oid;
    public static final ObjectIdentifier sha1WithRSAEncryption_oid;
    public static final ObjectIdentifier sha1WithRSAEncryption_OIW_oid;
    public static final ObjectIdentifier shaWithDSA_OIW_oid;
    public static final ObjectIdentifier sha1WithDSA_OIW_oid;
    public static final ObjectIdentifier sha1WithDSA_oid;

    static {
        e = new int[]{1, 2, 840, 113549, 2, 2};
        f = new int[]{1, 2, 840, 113549, 2, 5};
        g = new int[]{1, 3, 14, 3, 2, 26};
        MD2_oid = new ObjectIdentifier(e);
        MD5_oid = new ObjectIdentifier(f);
        SHA_oid = new ObjectIdentifier(g);
        h = new int[]{1, 2, 840, 113549, 1, 3, 1};
        i = new int[]{1, 2, 840, 10046, 2, 1};
        j = new int[]{1, 3, 14, 3, 2, 12};
        k = new int[]{1, 2, 840, 10040, 4, 1};
        l = new int[]{1, 2, 5, 8, 1, 1};
        m = new int[]{1, 2, 840, 113549, 1, 1, 1};
        DH_oid = new ObjectIdentifier(h);
        DH_PKIX_oid = new ObjectIdentifier(i);
        DSA_OIW_oid = new ObjectIdentifier(j);
        DSA_oid = new ObjectIdentifier(k);
        RSA_oid = new ObjectIdentifier(l);
        RSAEncryption_oid = new ObjectIdentifier(m);
        n = new int[]{1, 2, 840, 113549, 1, 1, 2};
        o = new int[]{1, 2, 840, 113549, 1, 1, 4};
        p = new int[]{1, 2, 840, 113549, 1, 1, 5};
        q = new int[]{1, 3, 14, 3, 2, 29};
        r = new int[]{1, 3, 14, 3, 2, 13};
        s = new int[]{1, 3, 14, 3, 2, 27};
        t = new int[]{1, 2, 840, 10040, 4, 3};
        md2WithRSAEncryption_oid = new ObjectIdentifier(n);
        md5WithRSAEncryption_oid = new ObjectIdentifier(o);
        sha1WithRSAEncryption_oid = new ObjectIdentifier(p);
        sha1WithRSAEncryption_OIW_oid = new ObjectIdentifier(q);
        shaWithDSA_OIW_oid = new ObjectIdentifier(r);
        sha1WithDSA_OIW_oid = new ObjectIdentifier(s);
        sha1WithDSA_oid = new ObjectIdentifier(t);
    }

    public AlgorithmId() {
    }

    public AlgorithmId(ObjectIdentifier objectIdentifier) {
        this.c = objectIdentifier;
    }

    private AlgorithmId(ObjectIdentifier objectIdentifier, DerValue derValue) throws IOException {
        this.c = objectIdentifier;
        this.params = derValue;
        if (this.params != null) {
            this.decodeParams();
        }
    }

    private String a() {
        if (this.c.equals(MD5_oid)) {
            return "MD5";
        }
        if (this.c.equals(MD2_oid)) {
            return "MD2";
        }
        if (this.c.equals(SHA_oid)) {
            return "SHA1";
        }
        if (this.c.equals(RSAEncryption_oid) || this.c.equals(RSA_oid)) {
            return "RSA";
        }
        if (this.c.equals(DH_oid) || this.c.equals(DH_PKIX_oid)) {
            return "Diffie-Hellman";
        }
        if (this.c.equals(DSA_oid) || this.c.equals(DSA_OIW_oid)) {
            return "DSA";
        }
        if (this.c.equals(md5WithRSAEncryption_oid)) {
            return "MD5withRSA";
        }
        if (this.c.equals(md2WithRSAEncryption_oid)) {
            return "MD2withRSA";
        }
        if (this.c.equals(sha1WithDSA_oid) || this.c.equals(sha1WithDSA_OIW_oid) || this.c.equals(shaWithDSA_OIW_oid)) {
            return "SHA1withDSA";
        }
        if (this.c.equals(sha1WithRSAEncryption_oid) || this.c.equals(sha1WithRSAEncryption_OIW_oid)) {
            return "SHA1withRSA";
        }
        return this.c.toString();
    }

    private static ObjectIdentifier a(String string) {
        if (string.indexOf(46) != -1) {
            if (string.startsWith("OID.")) {
                return new ObjectIdentifier(string.substring("OID.".length()));
            }
            return new ObjectIdentifier(string);
        }
        if (string.equalsIgnoreCase("MD5")) {
            return MD5_oid;
        }
        if (string.equalsIgnoreCase("MD2")) {
            return MD2_oid;
        }
        if (string.equalsIgnoreCase("SHA") || string.equalsIgnoreCase("SHA1") || string.equalsIgnoreCase("SHA-1")) {
            return SHA_oid;
        }
        if (string.equalsIgnoreCase("RSA")) {
            return RSAEncryption_oid;
        }
        if (string.equalsIgnoreCase("Diffie-Hellman") || string.equalsIgnoreCase("DH")) {
            return DH_oid;
        }
        if (string.equalsIgnoreCase("DSA")) {
            return DSA_oid;
        }
        if (string.equalsIgnoreCase("MD5withRSA") || string.equalsIgnoreCase("MD5/RSA")) {
            return md5WithRSAEncryption_oid;
        }
        if (string.equalsIgnoreCase("MD2withRSA") || string.equalsIgnoreCase("MD2/RSA")) {
            return md2WithRSAEncryption_oid;
        }
        if (string.equalsIgnoreCase("SHAwithDSA") || string.equalsIgnoreCase("SHA1withDSA") || string.equalsIgnoreCase("SHA/DSA") || string.equalsIgnoreCase("SHA1/DSA") || string.equalsIgnoreCase("DSAWithSHA1")) {
            return sha1WithDSA_oid;
        }
        if (string.equalsIgnoreCase("SHA1WithRSA") || string.equalsIgnoreCase("SHA1/RSA")) {
            return sha1WithRSAEncryption_OIW_oid;
        }
        if (!a) {
            Provider[] providerArray = Security.getProviders();
            int n2 = 0;
            while (n2 < providerArray.length) {
                Enumeration enumeration = ((Hashtable)providerArray[n2]).keys();
                while (enumeration.hasMoreElements()) {
                    int n3;
                    String string2 = (String)enumeration.nextElement();
                    if (!string2.toUpperCase().startsWith("ALG.ALIAS") || (n3 = string2.toUpperCase().indexOf("OID.", 0)) == -1) continue;
                    if ((n3 += "OID.".length()) == string2.length()) break;
                    if (b == null) {
                        b = new Hashtable(11);
                    }
                    String string3 = string2.substring(n3);
                    String string4 = ((Properties)providerArray[n2]).getProperty(string2).toUpperCase();
                    if (b.get(string4) != null) continue;
                    b.put(string4, new ObjectIdentifier(string3));
                }
                ++n2;
            }
            a = true;
        }
        return (ObjectIdentifier)b.get(string.toUpperCase());
    }

    protected void decodeParams() throws IOException {
        try {
            this.d = AlgorithmParameters.getInstance(this.c.toString());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.d = null;
            return;
        }
        this.d.init(this.params.toByteArray());
    }

    public void derEncode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream.putOID(this.c);
        if (this.params == null) {
            derOutputStream.putNull();
        } else {
            derOutputStream.putDerValue(this.params);
        }
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
    }

    public final byte[] encode() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putOID(this.c);
        if (this.params == null) {
            derOutputStream2.putNull();
        } else {
            derOutputStream2.putDerValue(this.params);
        }
        derOutputStream.write((byte)48, derOutputStream2);
        return derOutputStream.toByteArray();
    }

    public final void encode(DerOutputStream derOutputStream) throws IOException {
        this.derEncode(derOutputStream);
    }

    public boolean equals(AlgorithmId algorithmId) {
        if (!this.c.equals(algorithmId.c)) {
            return false;
        }
        if (this.params == null && algorithmId.params == null) {
            return true;
        }
        if (this.params == null) {
            return false;
        }
        return this.params.equals(algorithmId.params);
    }

    public final boolean equals(ObjectIdentifier objectIdentifier) {
        return this.c.equals(objectIdentifier);
    }

    public boolean equals(Object object) {
        if (object instanceof AlgorithmId) {
            return this.equals((AlgorithmId)object);
        }
        if (object instanceof ObjectIdentifier) {
            return this.equals((ObjectIdentifier)object);
        }
        return false;
    }

    public static AlgorithmId get(String string) throws NoSuchAlgorithmException {
        ObjectIdentifier objectIdentifier = AlgorithmId.a(string);
        if (objectIdentifier == null) {
            throw new NoSuchAlgorithmException("unrecognized algorithm name: " + string);
        }
        return new AlgorithmId(objectIdentifier);
    }

    public static AlgorithmId getAlgorithmId(String string) throws NoSuchAlgorithmException {
        return AlgorithmId.get(string);
    }

    public byte[] getEncodedParams() throws IOException {
        if (this.params == null) {
            return null;
        }
        return this.params.toByteArray();
    }

    public String getName() {
        return this.a();
    }

    public final ObjectIdentifier getOID() {
        return this.c;
    }

    public AlgorithmParameters getParameters() {
        return this.d;
    }

    public int hashCode() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.c.toString());
        stringBuffer.append(this.paramsToString());
        return stringBuffer.toString().hashCode();
    }

    protected String paramsToString() {
        if (this.params == null) {
            return "";
        }
        if (this.d != null) {
            return this.d.toString();
        }
        return ", params unparsed";
    }

    public static AlgorithmId parse(DerValue derValue) throws IOException {
        DerValue derValue2;
        if (derValue.tag != 48) {
            throw new IOException("algid parse error, not a sequence");
        }
        DerInputStream derInputStream = derValue.toDerInputStream();
        ObjectIdentifier objectIdentifier = derInputStream.getOID();
        if (derInputStream.available() == 0) {
            derValue2 = null;
        } else {
            derValue2 = derInputStream.getDerValue();
            if (derValue2.tag == 5) {
                derValue2 = null;
            }
        }
        AlgorithmId algorithmId = new AlgorithmId(objectIdentifier, derValue2);
        if (derValue2 != null) {
            algorithmId.decodeParams();
        }
        return algorithmId;
    }

    public String toString() {
        return String.valueOf(this.a()) + this.paramsToString();
    }
}

