/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.Util;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

class Security {
    private static final int SHA1_HASH_SIZE = 20;
    private static final char PVERSION41_CHAR = '*';

    private Security() {
    }

    static byte[] getBinaryPassword(int[] salt, boolean usingNewPasswords) throws NoSuchAlgorithmException {
        int val = 0;
        byte[] binaryPassword = new byte[20];
        if (usingNewPasswords) {
            int pos = 0;
            int i2 = 0;
            while (i2 < 4) {
                val = salt[i2];
                int t2 = 3;
                while (t2 >= 0) {
                    binaryPassword[pos++] = (byte)(val & 0xFF);
                    val >>= 8;
                    --t2;
                }
                ++i2;
            }
            return binaryPassword;
        }
        int offset = 0;
        int i3 = 0;
        while (i3 < 2) {
            val = salt[i3];
            int t3 = 3;
            while (t3 >= 0) {
                binaryPassword[t3 + offset] = (byte)(val % 256);
                val >>= 8;
                --t3;
            }
            offset += 4;
            ++i3;
        }
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        md.update(binaryPassword, 0, 8);
        return md.digest();
    }

    static byte[] createKeyFromOldPassword(String passwd) throws NoSuchAlgorithmException {
        passwd = Security.makeScrambledPassword(passwd);
        int[] salt = Security.getSaltFromPassword(passwd);
        return Security.getBinaryPassword(salt, false);
    }

    static String makeScrambledPassword(String password) throws NoSuchAlgorithmException {
        long[] passwordHash = Util.newHash(password);
        StringBuffer scramble = new StringBuffer();
        scramble.append(Security.longToHex(passwordHash[0]));
        scramble.append(Security.longToHex(passwordHash[1]));
        return scramble.toString();
    }

    static void passwordCrypt(byte[] from, byte[] to, byte[] password, int length) {
        int pos = 0;
        while (pos < from.length && pos < length) {
            to[pos] = (byte)(from[pos] ^ password[pos]);
            ++pos;
        }
    }

    static byte[] passwordHashStage1(String password) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        StringBuffer cleansedPassword = new StringBuffer();
        int passwordLength = password.length();
        int i2 = 0;
        while (i2 < passwordLength) {
            char c2 = password.charAt(i2);
            if (c2 != ' ' && c2 != '\t') {
                cleansedPassword.append(c2);
            }
            ++i2;
        }
        return md.digest(cleansedPassword.toString().getBytes());
    }

    static byte[] passwordHashStage2(byte[] hashedPassword, byte[] salt) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        md.update(salt, 0, 4);
        md.update(hashedPassword, 0, 20);
        return md.digest();
    }

    private static int[] getSaltFromPassword(String password) {
        int[] result = new int[6];
        if (password == null || password.length() == 0) {
            return result;
        }
        if (password.charAt(0) == '*') {
            String saltInHex = password.substring(1, 5);
            int val = 0;
            int i2 = 0;
            while (i2 < 4) {
                val = (val << 4) + Security.charVal(saltInHex.charAt(i2));
                ++i2;
            }
            return result;
        }
        int resultPos = 0;
        int pos = 0;
        int length = password.length();
        while (pos < length) {
            int val = 0;
            int i3 = 0;
            while (i3 < 8) {
                val = (val << 4) + Security.charVal(password.charAt(pos++));
                ++i3;
            }
            result[resultPos++] = val;
        }
        return result;
    }

    private static int charVal(char c2) {
        return c2 >= '0' && c2 <= '9' ? c2 - 48 : (c2 >= 'A' && c2 <= 'Z' ? c2 - 65 + 10 : c2 - 97 + 10);
    }

    private static String longToHex(long val) {
        String longHex = Long.toHexString(val);
        int length = longHex.length();
        if (length < 8) {
            int padding = 8 - length;
            StringBuffer buf = new StringBuffer();
            int i2 = 0;
            while (i2 < padding) {
                buf.append("0");
                ++i2;
            }
            buf.append(longHex);
            return buf.toString();
        }
        return longHex.substring(0, 8);
    }

    static byte[] scramble411(String password, String seed) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        byte[] passwordHashStage1 = md.digest(password.getBytes());
        md.reset();
        byte[] passwordHashStage2 = md.digest(passwordHashStage1);
        md.reset();
        byte[] seedAsBytes = seed.getBytes();
        md.update(seedAsBytes);
        md.update(passwordHashStage2);
        byte[] toBeXord = md.digest();
        int numToXor = toBeXord.length;
        int i2 = 0;
        while (i2 < numToXor) {
            toBeXord[i2] = (byte)(toBeXord[i2] ^ passwordHashStage1[i2]);
            ++i2;
        }
        return toBeXord;
    }

    static {
        SHA1_HASH_SIZE = 20;
        PVERSION41_CHAR = (char)42;
    }
}

