/*
 * Decompiled with CFR 0.152.
 */
package com.jscape.inet.ssh.transport;

import com.jscape.inet.ssh.transport.Message;
import com.jscape.inet.ssh.transport.MessageStream;
import com.jscape.inet.ssh.transport.TransportException;
import com.jscape.inet.ssh.transport.compression.Compression;
import com.jscape.inet.ssh.types.SshUint32;
import com.jscape.util.i;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.ShortBufferException;

public final class MessageWriter
extends MessageStream {
    private static final int b = 8;
    private static final int c = 4;
    private final DataOutputStream d;
    private final SecureRandom e = new SecureRandom();

    public MessageWriter(OutputStream outputStream, Compression compression, Cipher cipher, Mac mac) {
        this.d = new DataOutputStream(outputStream);
        this.setCompression(compression);
        this.setCipher(cipher);
        this.setMac(mac);
    }

    public void close() {
        try {
            this.d.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void writeLine(String string) throws IOException {
        this.d.writeUTF(string);
    }

    public synchronized void writeMessage(Message message) throws IOException {
        int n2 = Message.c;
        i.a(message);
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            message.writeTo(byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byte[] byArray2 = this.compression.update(byArray);
            byte[] byArray3 = this.b(byArray2.length);
            int n3 = byArray2.length + byArray3.length + 1;
            int n4 = 4 + n3;
            int n5 = n4 + this.mac.getMacLength();
            this.resizeBuffer(n5);
            SshUint32.store(n3, this.buffer, 0);
            this.buffer[4] = (byte)byArray3.length;
            System.arraycopy(byArray2, 0, this.buffer, 5, byArray2.length);
            System.arraycopy(byArray3, 0, this.buffer, 5 + byArray2.length, byArray3.length);
            this.a(n4);
            this.cipher.update(this.buffer, 0, n4, this.buffer, 0);
            this.d.write(this.buffer, 0, n5);
            this.d.flush();
            Arrays.fill(this.buffer, (byte)0);
            this.bytesCount += (long)n5;
        }
        catch (ShortBufferException shortBufferException) {
            throw new TransportException(shortBufferException.getMessage());
        }
        if (n2 != 0) {
            int n6 = i.a;
            i.a = ++n6;
        }
    }

    private void a(int n2) throws TransportException {
        long l2 = this.sequence.nextValue();
        try {
            this.updateMac(l2);
            this.mac.update(this.buffer, 0, n2);
            this.mac.doFinal(this.buffer, n2);
        }
        catch (ShortBufferException shortBufferException) {
            throw new TransportException(shortBufferException.getMessage());
        }
    }

    private byte[] b(int n2) {
        int n3;
        int n4 = 5 + n2;
        int n5 = this.cipher.getBlockSize();
        int n6 = Math.max(n5, 8);
        int n7 = n3 = n6 - n4 % n6;
        if (Message.c == 0) {
            if (n7 < 4) {
                n3 += n6;
            }
            n7 = n3;
        }
        byte[] byArray = new byte[n7];
        this.e.nextBytes(byArray);
        return byArray;
    }
}

