/*
 * Decompiled with CFR 0.152.
 */
package com.jscape.inet.sftp.v4.packets;

import com.jscape.inet.file.JFileType;
import com.jscape.inet.sftp.v4.packets.SftpFileAttributes2;
import com.jscape.inet.ssh.types.SshByte;
import com.jscape.util.i;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

public class SftpFileType {
    protected static final int SSH_FILEXFER_TYPE_REGULAR = 1;
    protected static final int SSH_FILEXFER_TYPE_DIRECTORY = 2;
    protected static final int SSH_FILEXFER_TYPE_SYMLINK = 3;
    protected static final int SSH_FILEXFER_TYPE_SPECIAL = 4;
    protected static final int SSH_FILEXFER_TYPE_UNKNOWN = 5;
    protected static Map codeMap = new HashMap();

    public static JFileType readFrom(InputStream inputStream, String string) throws IOException {
        int n2 = SshByte.readIntFrom(inputStream);
        return SftpFileType.findTypeFor(n2);
    }

    public static void writeTypeTo(JFileType jFileType, OutputStream outputStream) throws IOException {
        i.a(jFileType);
        i.a(outputStream);
        int n2 = (Integer)codeMap.get(jFileType);
        SshByte.writeIntTo(n2, outputStream);
    }

    protected static JFileType findTypeFor(int n2) {
        boolean bl = SftpFileAttributes2.j;
        for (Map.Entry entry : codeMap.entrySet()) {
            int n3 = (Integer)entry.getValue();
            if (n3 == n2) {
                return (JFileType)entry.getKey();
            }
            if (!bl) continue;
        }
        return JFileType.UNKNOWN;
    }

    static {
        codeMap.put(JFileType.REGULAR, new Integer(1));
        codeMap.put(JFileType.DIRECTORY, new Integer(2));
        codeMap.put(JFileType.SYMBOLIC, new Integer(3));
        codeMap.put(JFileType.SOCKET, new Integer(4));
        codeMap.put(JFileType.BLOCK_ORIENTED, new Integer(4));
        codeMap.put(JFileType.CHAR_ORIENTED, new Integer(4));
        codeMap.put(JFileType.FIFO, new Integer(4));
        codeMap.put(JFileType.UNKNOWN, new Integer(5));
    }
}

